package com.prrsoft.methodex.network

import com.android.volley.AuthFailureError
import com.android.volley.Request
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.prrsoft.methodex.util.Constants
import java.util.HashMap

class RequestFroStatus(
    user_id: String,
    listener: Response.Listener<String>,
    errorListener: Response.ErrorListener
) : StringRequest(Request.Method.POST, GET_PAID_STATUS, listener, errorListener) {
    private val parameters: MutableMap<String, String>

    init {
        parameters = HashMap()
        parameters["app_key"] = Constants.API_KEYV
        parameters["user_id"] = user_id
    }

    @Throws(AuthFailureError::class)
    override fun getParams(): Map<String, String> {
        return parameters
    }

    companion object {
        private val GET_PAID_STATUS = Constants.GET_PAID_STATUS
    }
}