package com.prrsoft.methodex.network

import com.android.volley.AuthFailureError
import com.android.volley.Request
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.prrsoft.methodex.util.Constants
import java.util.HashMap

class RequestForSpficationList(
    cust_id: String,
    item_id: String,

    listener: Response.Listener<String>,
    errorListener: Response.ErrorListener
) : StringRequest(Request.Method.POST, GET_SPECIFICATION_LIST_DATA_LIST, listener, errorListener) {
    private val parameters: MutableMap<String, String>

    init {
        parameters = HashMap()
        parameters["app_key"] = Constants.API_KEYV
        parameters["cust_id"] = cust_id
        parameters["item_id"] = item_id
    }

    @Throws(AuthFailureError::class)
    override fun getParams(): Map<String, String> {
        return parameters
    }

    companion object {
        private val GET_SPECIFICATION_LIST_DATA_LIST = Constants.GET_SPECIFICATION_LIST_DATA_LIST
    }
}