package com.prrsoft.methodex.network

import com.android.volley.AuthFailureError
import com.android.volley.Request
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.prrsoft.methodex.util.Constants
import java.util.HashMap

class RequestForSaveData(
    cust_id: String,
    item_id: String,
    boq_quantity: String,
    boq_amount: String,
    Weightage: String,
    executed_quantity: String,
    speid: String,
    listener: Response.Listener<String>,
    errorListener: Response.ErrorListener
) : StringRequest(Request.Method.POST, GET_SAVE_DATA, listener, errorListener) {
    private val parameters: MutableMap<String, String>

    init {
        parameters = HashMap()
        parameters["app_key"] = Constants.API_KEYV
        parameters["cust_id"] = cust_id
        parameters["item_id"] = item_id
        parameters["boq_quantity"] = boq_quantity
        parameters["boq_amount"] = boq_amount
        parameters["Weightage"] = Weightage
        parameters["executed_quantity"] = executed_quantity
        parameters["id"] = speid
    }

    @Throws(AuthFailureError::class)
    override fun getParams(): Map<String, String> {
        return parameters
    }

    companion object {
        private val GET_SAVE_DATA = Constants.GET_SAVE_DATA
    }
}