package com.prrsoft.methodex.network

import com.android.volley.AuthFailureError
import com.android.volley.Request
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.prrsoft.methodex.util.Constants
import java.util.HashMap

class RequestForFindPercentage(
    boq_quantity: String,
    weightage: String,
    executed_quantity: String,
    id: String,

    listener: Response.Listener<String>,
    errorListener: Response.ErrorListener
) : StringRequest(Request.Method.POST, GET_FIND_PERCENTAGE, listener, errorListener) {
    private val parameters: MutableMap<String, String>

    init {
        parameters = HashMap()
        parameters["app_key"] = Constants.API_KEYV
        parameters["boq_quantity"] = boq_quantity
        parameters["Weightage"] = weightage
        parameters["executed_quantity"] = executed_quantity
        parameters["id"] = id
    }

    @Throws(AuthFailureError::class)
    override fun getParams(): Map<String, String> {
        return parameters
    }

    companion object {
        private val GET_FIND_PERCENTAGE = Constants.GET_FIND_PERCENTAGE
    }
}