package com.prrsoft.methodex

import android.app.Activity
import android.app.Application
import com.android.volley.Request
import com.android.volley.RequestQueue
import com.android.volley.toolbox.Volley
import com.prrsoft.methodex.di.component.DaggerAppComponent
import dagger.android.DispatchingAndroidInjector
import dagger.android.HasActivityInjector
import javax.inject.Inject

class CIApp : Application(),HasActivityInjector {

    @Inject
    lateinit internal var activityDispatchingAndroidInjector: DispatchingAndroidInjector<Activity>


    override fun activityInjector() = activityDispatchingAndroidInjector


    override fun onCreate() {
        super.onCreate()
        instance = this
        DaggerAppComponent.builder()
                .application(this)
                .build()
                .inject(this)
    }

    val requestQueue: RequestQueue? = null
        get() {
            if (field == null) {
                return Volley.newRequestQueue(applicationContext)
            }
            return field
        }

    fun <T> addToRequestQueue(request: Request<T>) {
        request.tag = TAG
        requestQueue?.add(request)
    }

    companion object {
        private val TAG = CIApp::class.java.simpleName
        @get:Synchronized
        var instance: CIApp? = null
            private set
    }

}