package com.prrsoft.methodex;

import android.databinding.DataBinderMapper;
import android.databinding.DataBindingComponent;
import android.databinding.ViewDataBinding;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import com.prrsoft.methodex.databinding.ActivityAboutBindingImpl;
import com.prrsoft.methodex.databinding.ActivityItemListBindingImpl;
import com.prrsoft.methodex.databinding.ActivityLoginScreenBindingImpl;
import com.prrsoft.methodex.databinding.ActivityMainBindingImpl;
import com.prrsoft.methodex.databinding.ActivityPrivacyPolicyBindingImpl;
import com.prrsoft.methodex.databinding.ActivitySignUpBindingImpl;
import com.prrsoft.methodex.databinding.ActivitySpecificationListBindingImpl;
import com.prrsoft.methodex.databinding.ActivitySpeficationFieldBindingImpl;
import com.prrsoft.methodex.databinding.ActivitySplashScreenBindingImpl;
import com.prrsoft.methodex.databinding.ActivityVeryFyOtpBindingImpl;
import com.prrsoft.methodex.databinding.BossTipsFragmentBindingImpl;
import com.prrsoft.methodex.databinding.BossTipsPlanFragmentBindingImpl;
import com.prrsoft.methodex.databinding.FreeTipsFragmentBindingImpl;
import com.prrsoft.methodex.databinding.HomeFragmentBindingImpl;
import com.prrsoft.methodex.databinding.NewsDetailsFragmentBindingImpl;
import com.prrsoft.methodex.databinding.StockMarketFragmentBindingImpl;
import com.prrsoft.methodex.databinding.TopNewsFragmentBindingImpl;
import com.prrsoft.methodex.databinding.WinSubscriptionFragmentBindingImpl;
import java.lang.IllegalArgumentException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataBinderMapperImpl extends DataBinderMapper {
  private static final int LAYOUT_ACTIVITYABOUT = 1;

  private static final int LAYOUT_ACTIVITYITEMLIST = 2;

  private static final int LAYOUT_ACTIVITYLOGINSCREEN = 3;

  private static final int LAYOUT_ACTIVITYMAIN = 4;

  private static final int LAYOUT_ACTIVITYPRIVACYPOLICY = 5;

  private static final int LAYOUT_ACTIVITYSIGNUP = 6;

  private static final int LAYOUT_ACTIVITYSPECIFICATIONLIST = 7;

  private static final int LAYOUT_ACTIVITYSPEFICATIONFIELD = 8;

  private static final int LAYOUT_ACTIVITYSPLASHSCREEN = 9;

  private static final int LAYOUT_ACTIVITYVERYFYOTP = 10;

  private static final int LAYOUT_BOSSTIPSFRAGMENT = 11;

  private static final int LAYOUT_BOSSTIPSPLANFRAGMENT = 12;

  private static final int LAYOUT_FREETIPSFRAGMENT = 13;

  private static final int LAYOUT_HOMEFRAGMENT = 14;

  private static final int LAYOUT_NEWSDETAILSFRAGMENT = 15;

  private static final int LAYOUT_STOCKMARKETFRAGMENT = 16;

  private static final int LAYOUT_TOPNEWSFRAGMENT = 17;

  private static final int LAYOUT_WINSUBSCRIPTIONFRAGMENT = 18;

  private static final SparseIntArray INTERNAL_LAYOUT_ID_LOOKUP = new SparseIntArray(18);

  static {
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_about, LAYOUT_ACTIVITYABOUT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_item_list, LAYOUT_ACTIVITYITEMLIST);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_login_screen, LAYOUT_ACTIVITYLOGINSCREEN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_main, LAYOUT_ACTIVITYMAIN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_privacy_policy, LAYOUT_ACTIVITYPRIVACYPOLICY);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_sign_up, LAYOUT_ACTIVITYSIGNUP);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_specification_list, LAYOUT_ACTIVITYSPECIFICATIONLIST);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_spefication_field, LAYOUT_ACTIVITYSPEFICATIONFIELD);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_splash_screen, LAYOUT_ACTIVITYSPLASHSCREEN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.activity_very_fy_otp, LAYOUT_ACTIVITYVERYFYOTP);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.boss_tips_fragment, LAYOUT_BOSSTIPSFRAGMENT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.boss_tips_plan_fragment, LAYOUT_BOSSTIPSPLANFRAGMENT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.free_tips_fragment, LAYOUT_FREETIPSFRAGMENT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.home_fragment, LAYOUT_HOMEFRAGMENT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.news_details_fragment, LAYOUT_NEWSDETAILSFRAGMENT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.stock_market_fragment, LAYOUT_STOCKMARKETFRAGMENT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.top_news_fragment, LAYOUT_TOPNEWSFRAGMENT);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.prrsoft.methodex.R.layout.win_subscription_fragment, LAYOUT_WINSUBSCRIPTIONFRAGMENT);
  }

  @Override
  public ViewDataBinding getDataBinder(DataBindingComponent component, View view, int layoutId) {
    int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
    if(localizedLayoutId > 0) {
      final Object tag = view.getTag();
      if(tag == null) {
        throw new RuntimeException("view must have a tag");
      }
      switch(localizedLayoutId) {
        case  LAYOUT_ACTIVITYABOUT: {
          if ("layout/activity_about_0".equals(tag)) {
            return new ActivityAboutBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_about is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYITEMLIST: {
          if ("layout/activity_item_list_0".equals(tag)) {
            return new ActivityItemListBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_item_list is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYLOGINSCREEN: {
          if ("layout/activity_login_screen_0".equals(tag)) {
            return new ActivityLoginScreenBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_login_screen is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYMAIN: {
          if ("layout/activity_main_0".equals(tag)) {
            return new ActivityMainBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_main is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYPRIVACYPOLICY: {
          if ("layout/activity_privacy_policy_0".equals(tag)) {
            return new ActivityPrivacyPolicyBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_privacy_policy is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYSIGNUP: {
          if ("layout/activity_sign_up_0".equals(tag)) {
            return new ActivitySignUpBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_sign_up is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYSPECIFICATIONLIST: {
          if ("layout/activity_specification_list_0".equals(tag)) {
            return new ActivitySpecificationListBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_specification_list is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYSPEFICATIONFIELD: {
          if ("layout/activity_spefication_field_0".equals(tag)) {
            return new ActivitySpeficationFieldBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_spefication_field is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYSPLASHSCREEN: {
          if ("layout/activity_splash_screen_0".equals(tag)) {
            return new ActivitySplashScreenBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_splash_screen is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYVERYFYOTP: {
          if ("layout/activity_very_fy_otp_0".equals(tag)) {
            return new ActivityVeryFyOtpBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_very_fy_otp is invalid. Received: " + tag);
        }
        case  LAYOUT_BOSSTIPSFRAGMENT: {
          if ("layout/boss_tips_fragment_0".equals(tag)) {
            return new BossTipsFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for boss_tips_fragment is invalid. Received: " + tag);
        }
        case  LAYOUT_BOSSTIPSPLANFRAGMENT: {
          if ("layout/boss_tips_plan_fragment_0".equals(tag)) {
            return new BossTipsPlanFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for boss_tips_plan_fragment is invalid. Received: " + tag);
        }
        case  LAYOUT_FREETIPSFRAGMENT: {
          if ("layout/free_tips_fragment_0".equals(tag)) {
            return new FreeTipsFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for free_tips_fragment is invalid. Received: " + tag);
        }
        case  LAYOUT_HOMEFRAGMENT: {
          if ("layout/home_fragment_0".equals(tag)) {
            return new HomeFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for home_fragment is invalid. Received: " + tag);
        }
        case  LAYOUT_NEWSDETAILSFRAGMENT: {
          if ("layout/news_details_fragment_0".equals(tag)) {
            return new NewsDetailsFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for news_details_fragment is invalid. Received: " + tag);
        }
        case  LAYOUT_STOCKMARKETFRAGMENT: {
          if ("layout/stock_market_fragment_0".equals(tag)) {
            return new StockMarketFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for stock_market_fragment is invalid. Received: " + tag);
        }
        case  LAYOUT_TOPNEWSFRAGMENT: {
          if ("layout/top_news_fragment_0".equals(tag)) {
            return new TopNewsFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for top_news_fragment is invalid. Received: " + tag);
        }
        case  LAYOUT_WINSUBSCRIPTIONFRAGMENT: {
          if ("layout/win_subscription_fragment_0".equals(tag)) {
            return new WinSubscriptionFragmentBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for win_subscription_fragment is invalid. Received: " + tag);
        }
      }
    }
    return null;
  }

  @Override
  public ViewDataBinding getDataBinder(DataBindingComponent component, View[] views, int layoutId) {
    if(views == null || views.length == 0) {
      return null;
    }
    int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
    if(localizedLayoutId > 0) {
      final Object tag = views[0].getTag();
      if(tag == null) {
        throw new RuntimeException("view must have a tag");
      }
      switch(localizedLayoutId) {
      }
    }
    return null;
  }

  @Override
  public int getLayoutId(String tag) {
    if (tag == null) {
      return 0;
    }
    Integer tmpVal = InnerLayoutIdLookup.sKeys.get(tag);
    return tmpVal == null ? 0 : tmpVal;
  }

  @Override
  public String convertBrIdToString(int localId) {
    String tmpVal = InnerBrLookup.sKeys.get(localId);
    return tmpVal;
  }

  @Override
  public List<DataBinderMapper> collectDependencies() {
    ArrayList<DataBinderMapper> result = new ArrayList<DataBinderMapper>(1);
    result.add(new com.android.databinding.library.baseAdapters.DataBinderMapperImpl());
    return result;
  }

  private static class InnerBrLookup {
    static final SparseArray<String> sKeys = new SparseArray<String>(3);

    static {
      sKeys.put(0, "_all");
      sKeys.put(1, "viewModel");
    }
  }

  private static class InnerLayoutIdLookup {
    static final HashMap<String, Integer> sKeys = new HashMap<String, Integer>(18);

    static {
      sKeys.put("layout/activity_about_0", com.prrsoft.methodex.R.layout.activity_about);
      sKeys.put("layout/activity_item_list_0", com.prrsoft.methodex.R.layout.activity_item_list);
      sKeys.put("layout/activity_login_screen_0", com.prrsoft.methodex.R.layout.activity_login_screen);
      sKeys.put("layout/activity_main_0", com.prrsoft.methodex.R.layout.activity_main);
      sKeys.put("layout/activity_privacy_policy_0", com.prrsoft.methodex.R.layout.activity_privacy_policy);
      sKeys.put("layout/activity_sign_up_0", com.prrsoft.methodex.R.layout.activity_sign_up);
      sKeys.put("layout/activity_specification_list_0", com.prrsoft.methodex.R.layout.activity_specification_list);
      sKeys.put("layout/activity_spefication_field_0", com.prrsoft.methodex.R.layout.activity_spefication_field);
      sKeys.put("layout/activity_splash_screen_0", com.prrsoft.methodex.R.layout.activity_splash_screen);
      sKeys.put("layout/activity_very_fy_otp_0", com.prrsoft.methodex.R.layout.activity_very_fy_otp);
      sKeys.put("layout/boss_tips_fragment_0", com.prrsoft.methodex.R.layout.boss_tips_fragment);
      sKeys.put("layout/boss_tips_plan_fragment_0", com.prrsoft.methodex.R.layout.boss_tips_plan_fragment);
      sKeys.put("layout/free_tips_fragment_0", com.prrsoft.methodex.R.layout.free_tips_fragment);
      sKeys.put("layout/home_fragment_0", com.prrsoft.methodex.R.layout.home_fragment);
      sKeys.put("layout/news_details_fragment_0", com.prrsoft.methodex.R.layout.news_details_fragment);
      sKeys.put("layout/stock_market_fragment_0", com.prrsoft.methodex.R.layout.stock_market_fragment);
      sKeys.put("layout/top_news_fragment_0", com.prrsoft.methodex.R.layout.top_news_fragment);
      sKeys.put("layout/win_subscription_fragment_0", com.prrsoft.methodex.R.layout.win_subscription_fragment);
    }
  }
}
